IF OBJECT_ID('UFD_EXP_CTB_MOV_CARTAO_DEV') IS NOT NULL
	BEGIN
		DROP FUNCTION UFD_EXP_CTB_MOV_CARTAO_DEV
	END
	
GO 
   
 
CREATE FUNCTION UFD_EXP_CTB_MOV_CARTAO_DEV(@CD_EMP		INT,
										   @CD_FILIAL	INT,
										   @DT_INI		DATETIME,
										   @DT_FIM		DATETIME)		
			
RETURNS @RS_RETURN TABLE(
		CD_EMP				INT, 
		CD_FILIAL			INT, 
		DT_VD				DATETIME,
		CD_CLI				INT, 
		RZ_CLI				VARCHAR(100),		
		VLR_CARTAO			MONEY)
AS
BEGIN
	
	INSERT INTO @RS_RETURN 
		SELECT 
			PDV_VD.CD_EMP, 
			PDV_VD.CD_FILIAL, 
			PDV_VD.DT_VD, 
			RC_CLI.CD_CLI, 
			RC_CLI.RZ_CLI, 
			SUM(PDV_VD.VLR_CARTAO) As VLR_CARTAO 
    
		FROM 
			PDV_VD 
			INNER JOIN RC_ADM_CARTAO_RC_CLI ON
				PDV_VD.CD_EMP			= RC_ADM_CARTAO_RC_CLI.CD_EMP
				AND PDV_VD.CD_ADM_CARTAO	= RC_ADM_CARTAO_RC_CLI.CD_ADM_CARTAO
			INNER JOIN PDV_VD_CANCEL_TEF ON
				PDV_VD_CANCEL_TEF.CD_VD = PDV_VD.CD_VD 
				AND PDV_VD_CANCEL_TEF.CD_FILIAL = PDV_VD.CD_FILIAL 
				AND PDV_VD_CANCEL_TEF.CD_EMP = PDV_VD.CD_EMP			
			INNER JOIN RC_CLI ON
				RC_ADM_CARTAO_RC_CLI.CD_EMP = RC_CLI.CD_EMP 
				AND RC_ADM_CARTAO_RC_CLI.CD_CLI = RC_CLI.CD_CLI

		WHERE PDV_VD.CD_EMP			= @CD_EMP
			AND PDV_VD.CD_FILIAL	= @CD_FILIAL
			AND PDV_VD.ST_VD		= 0
			AND PDV_VD.DT_VD		BETWEEN @DT_INI AND @DT_FIM
		
		GROUP BY PDV_VD.CD_EMP, PDV_VD.CD_FILIAL, PDV_VD.DT_VD, RC_CLI.CD_CLI, RC_CLI.RZ_CLI

	RETURN
		
END		